//====================================================
// Diffuse with Directional Lighting
//====================================================

//--------------
// un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;   
 
//--------------
// tweaks
//--------------

//constants for plugin testing, not actually used within the shader
   matrix TestMat={1.0f,0.0f,0.0f,0.0f, 0.0f,0.0f,1.0f,0.0f, 0.0f,-1.0f,0.0f,0.0f, 0.0f,0.0f,0.0f,1.0f};
   float4 TestVecArr[10];
   matrix TestMatArr[10];
//end of test constants

   float3 Ambient={0.2f,0.2f,0.2f};
   float3 LightDir={0.5f,-0.5f,-0.5f};
   float3 LightColor={1.0f,1.0f,1.0f};

//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler2D Base = sampler_state 
    {
 	texture = <BaseTX>;
	mipfilter = anisotropic;
	minfilter = anisotropic;
	magfilter = anisotropic;
    };

//--------------
// structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION; 
 	float2 UV:TEXCOORD; 
	float3 Normal:NORMAL;
     };
   struct output
     {
	float4 OPos:POSITION; 
 	float2 Tex:TEXCOORD0; 
	float3 WNormal:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   output VS(input IN) 
     {
 	output OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
 	OUT.Tex=IN.UV;
	OUT.WNormal=normalize(mul(IN.Normal,World));

	return OUT;
     }

//--------------
// pixel shader
//--------------
    float4 PS(output IN)  : COLOR
     {
	float4 Texture=tex2D(Base,IN.Tex); 
	float Light=saturate(dot(IN.WNormal,normalize(-LightDir)));
	return Texture*float4(Light+Ambient,1.0f);
     }

//--------------
// techniques   
//--------------
   technique Diffuse
      {
 	pass p1
      {		
 	vertexShader = compile vs_2_0 VS(); 
 	pixelShader  = compile ps_2_0 PS();
      }
      }